/*
 * InformationTableModel.h
 *
 *  Created on: 28.10.2009
 *      Author: stefan.detter
 */

#ifndef INFORMATIONTABLEMODEL_H_
#define INFORMATIONTABLEMODEL_H_

#include <QObject>
#include <QAbstractTableModel>

#include "../data/TreeItem.h"

class InformationTableModel : public QAbstractTableModel
{
	Q_OBJECT

public:
	InformationTableModel(QObject* parent = 0);
	virtual ~InformationTableModel();

	int rowCount(const QModelIndex &parent) const;
	int columnCount(const QModelIndex &parent) const;
	QVariant data(const QModelIndex &index, int role) const;
	QVariant headerData(int section, Qt::Orientation orientation, int role) const;

public slots:
	void setInformationItem(const TreeItem* t);
	void itemInformationChanged(int first, int last);
	void itemInformationBeginInsertRow(int index);
	void itemInformationEndInsertRow();

signals:
	void aboutToReset();
	void reset();

private:
	const TreeItem* m_infoItem;

};

#endif /* INFORMATIONTABLEMODEL_H_ */
